/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jdk.internal.dynalink.beans.StaticClass;
import noppes.npcs.LogWriter;
import noppes.npcs.api.handler.IDataObject;
import noppes.npcs.api.handler.data.IDataElement;
import noppes.npcs.util.CustomNPCsScheduler;
import noppes.npcs.util.Util;

public class DataObject
implements IDataObject {
    private static final Map<String, String> obfuscated = new HashMap<String, String>();
    public List<IDataElement> data;
    public Object object;

    public static void load() {
        CustomNPCsScheduler.runTack(() -> {
            obfuscated.clear();
            String data = Util.instance.getDataFile("obf.dat");
            if (data.isEmpty()) {
                return;
            }
            for (String line : data.split("\n")) {
                if (!line.contains("=")) continue;
                String[] d = line.split("=");
                obfuscated.put(d[0], d[1]);
            }
        });
    }

    @Nonnull
    public static String getObfuscatedName(String name) {
        if (obfuscated.containsKey(name)) {
            return obfuscated.get(name);
        }
        return "";
    }

    public DataObject(Object obj) {
        if (obj != null && obj.getClass().getSimpleName().equals("StaticClass")) {
            obj = ((StaticClass)obj).getRepresentedClass();
        }
        this.object = obj;
        this.data = Util.instance.getClassData(obj, false, true);
    }

    @Override
    public String get() {
        IDataElement[] ms;
        IDataElement[] fs;
        StringBuilder builder = new StringBuilder();
        builder.append("Class \"").append(this.object).append("\":");
        IDataElement[] cs = this.getClasses();
        if (cs.length > 0) {
            ArrayList<String> list = new ArrayList<String>();
            for (IDataElement ide : cs) {
                list.add("" + ide.getValue());
            }
            Collections.sort(list);
            int i = 0;
            builder.append('\n').append("Classes:[");
            for (String str : list) {
                builder.append(str);
                if (i < list.size() - 1) {
                    builder.append(", ");
                }
                ++i;
            }
            builder.append("]");
        }
        if ((fs = this.getFields()).length > 0) {
            ArrayList<String> list = new ArrayList<String>();
            for (IDataElement ide : fs) {
                list.add(((Field)ide.getObject()).getName());
            }
            Collections.sort(list);
            int i = 0;
            builder.append('\n').append("Fields:[");
            for (String str : list) {
                builder.append(str);
                if (i < list.size() - 1) {
                    builder.append(", ");
                }
                ++i;
            }
            builder.append("]");
        }
        if ((ms = this.getMethods()).length > 0) {
            ArrayList<String> list = new ArrayList<String>();
            for (IDataElement ide : ms) {
                list.add(((Method)ide.getObject()).getName());
            }
            Collections.sort(list);
            int i = 0;
            builder.append('\n').append("Methods:[");
            for (String str : list) {
                builder.append(str);
                if (i < list.size() - 1) {
                    builder.append(", ");
                }
                ++i;
            }
            builder.append("]");
        }
        return builder.toString();
    }

    @Override
    public IDataElement[] getClasses() {
        ArrayList<IDataElement> c = new ArrayList<IDataElement>();
        for (IDataElement de : this.data) {
            if (!(de.getObject() instanceof Class)) continue;
            c.add(de);
        }
        return c.toArray(new IDataElement[0]);
    }

    @Override
    public String getClassesInfo() {
        StringBuilder builder = new StringBuilder();
        ArrayList<IDataElement> c = new ArrayList<IDataElement>();
        for (IDataElement de : this.data) {
            if (!(de.getObject() instanceof Class)) continue;
            c.add(de);
        }
        int i = 0;
        if (!c.isEmpty()) {
            builder.append("Sub-Classes: [").append('\n');
            StringBuilder sp = new StringBuilder(" ");
            for (int j = 0; j < String.valueOf(c.size()).length() - String.valueOf(i).length(); ++j) {
                sp.append(" ");
            }
            for (IDataElement de : c) {
                builder.append(" ").append(i).append((CharSequence)sp).append(de.getData()).append('\n');
                ++i;
            }
            builder.append("]");
        }
        return builder.toString();
    }

    @Override
    public IDataElement getClazz(String name) {
        for (IDataElement de : this.data) {
            if (!(de.getObject() instanceof Class) || !de.getData().equals(name)) continue;
            return de;
        }
        return null;
    }

    @Override
    public IDataElement[] getConstructors() {
        ArrayList<IDataElement> c = new ArrayList<IDataElement>();
        for (IDataElement de : this.data) {
            if (!(de.getObject() instanceof Constructor)) continue;
            c.add(de);
        }
        return c.toArray(new IDataElement[0]);
    }

    @Override
    public String getConstructorsInfo() {
        StringBuilder builder = new StringBuilder();
        ArrayList<IDataElement> c = new ArrayList<IDataElement>();
        for (IDataElement de : this.data) {
            if (!(de.getObject() instanceof Constructor)) continue;
            c.add(de);
        }
        int i = 0;
        if (!c.isEmpty()) {
            builder.append("Constructors: [").append('\n');
            StringBuilder sp = new StringBuilder(" ");
            for (int j = 0; j < String.valueOf(c.size()).length() - String.valueOf(i).length(); ++j) {
                sp.append(" ");
            }
            for (IDataElement de : c) {
                builder.append(" ").append(i).append((CharSequence)sp).append(de.getData()).append('\n');
                ++i;
            }
            builder.append("]");
        }
        return builder.toString();
    }

    @Override
    public IDataElement getField(String name) {
        int pos = -1;
        try {
            pos = Integer.parseInt(name);
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        int i = 0;
        for (IDataElement de : this.data) {
            if (i == pos || de.getObject() instanceof Field && de.getName().equals(name)) {
                return de;
            }
            ++i;
        }
        return null;
    }

    @Override
    public IDataElement[] getFields() {
        ArrayList<IDataElement> f = new ArrayList<IDataElement>();
        for (IDataElement de : this.data) {
            if (!(de.getObject() instanceof Field)) continue;
            f.add(de);
        }
        return f.toArray(new IDataElement[0]);
    }

    @Override
    public String getFieldsInfo() {
        StringBuilder builder = new StringBuilder();
        HashMap<String, IDataElement> f = new HashMap<String, IDataElement>();
        for (IDataElement de : this.data) {
            if (!(de.getObject() instanceof Field)) continue;
            f.put(de.getName(), de);
        }
        if (!f.isEmpty()) {
            ArrayList names = new ArrayList(f.keySet());
            Collections.sort(names);
            LinkedHashMap<Integer, String> dataMap = new LinkedHashMap<Integer, String>();
            LinkedHashMap<Integer, String> ptMap = new LinkedHashMap<Integer, String>();
            LinkedHashMap<Integer, String> prMap = new LinkedHashMap<Integer, String>();
            LinkedHashMap<Integer, String> dMap = new LinkedHashMap<Integer, String>();
            LinkedHashMap<Integer, Object> valueMap = new LinkedHashMap<Integer, Object>();
            String maxKey = "";
            String maxValue = "";
            int i = 0;
            for (IDataElement de : f.values()) {
                String data = de.getData();
                Object value = de.getValue();
                if (data.length() > maxKey.length()) {
                    maxKey = data;
                }
                if (("" + value).length() > maxValue.length()) {
                    maxValue = "" + value;
                }
                if (data.startsWith("public")) {
                    dataMap.put(i, data);
                } else if (data.startsWith("protected")) {
                    ptMap.put(i, data);
                } else if (data.startsWith("private")) {
                    prMap.put(i, data);
                } else {
                    dMap.put(i, data);
                }
                valueMap.put(i, value);
                ++i;
            }
            dataMap.putAll(ptMap);
            dataMap.putAll(prMap);
            dataMap.putAll(dMap);
            builder.append("Fields: [").append('\n');
            Iterator<Object> iterator = dataMap.keySet().iterator();
            while (iterator.hasNext()) {
                int j;
                int pos = (Integer)iterator.next();
                StringBuilder sp = new StringBuilder(" ");
                StringBuilder fx = new StringBuilder();
                for (j = 0; j < String.valueOf(names.size()).length() - String.valueOf(pos).length(); ++j) {
                    sp.append(" ");
                }
                for (j = 0; j < maxKey.length() - ((String)dataMap.get(pos)).length(); ++j) {
                    fx.append(" ");
                }
                builder.append(" ").append(pos).append((CharSequence)sp).append((String)dataMap.get(pos)).append((CharSequence)fx).append(" = ").append(valueMap.get(pos)).append('\n');
            }
            builder.append("]");
        }
        return builder.toString();
    }

    @Override
    public String getInfo() {
        Class<?>[] implementers;
        StringBuilder builder = new StringBuilder();
        int md = this.object.getClass().getModifiers();
        String key = "";
        if (Modifier.isPrivate(md)) {
            key = "Private ";
        } else if (Modifier.isPublic(md)) {
            key = "Public ";
        } else if (Modifier.isProtected(md)) {
            key = "Protected ";
        }
        if (Modifier.isAbstract(md)) {
            key = key + "Abstract";
        }
        if (Modifier.isInterface(md)) {
            key = key + "Interface";
        }
        builder.append(key).append("Class ").append(this.object.getClass().getName());
        if (this.object.getClass().getSuperclass() != null && this.object.getClass().getSuperclass() != Object.class) {
            builder.append(" extends ").append(Util.getAgrName(this.object.getClass().getSuperclass()));
        }
        if ((implementers = this.object.getClass().getInterfaces()).length > 0) {
            builder.append(" implements ");
            for (int i = 0; i < implementers.length; ++i) {
                builder.append(Util.getAgrName(implementers[i]));
                if (i >= implementers.length - 1) continue;
                builder.append(", ");
            }
        }
        builder.append(":").append('\n').append("As an object: ").append(this.object).append('\n');
        String values = this.getConstructorsInfo();
        if (!values.isEmpty()) {
            builder.append(values).append('\n');
        }
        if (!(values = this.getClassesInfo()).isEmpty()) {
            builder.append(values).append('\n');
        }
        if (!(values = this.getFieldsInfo()).isEmpty()) {
            builder.append(values).append('\n');
        }
        if (!(values = this.getMethodsInfo()).isEmpty()) {
            builder.append(values);
        }
        return builder.toString();
    }

    @Override
    public IDataElement getMethod(String name) {
        int pos = -1;
        try {
            pos = Integer.parseInt(name);
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        int i = 0;
        for (IDataElement de : this.data) {
            if (i == pos || de.getObject() instanceof Method && de.getName().equals(name)) {
                return de;
            }
            ++i;
        }
        return null;
    }

    @Override
    public IDataElement[] getMethods() {
        ArrayList<IDataElement> m = new ArrayList<IDataElement>();
        for (IDataElement de : this.data) {
            if (!(de.getObject() instanceof Method)) continue;
            m.add(de);
        }
        return m.toArray(new IDataElement[0]);
    }

    @Override
    public String getMethodsInfo() {
        StringBuilder builder = new StringBuilder();
        HashMap<String, IDataElement> m = new HashMap<String, IDataElement>();
        for (IDataElement de : this.data) {
            if (!(de.getObject() instanceof Method)) continue;
            m.put(de.getName(), de);
        }
        if (!m.isEmpty()) {
            ArrayList names = new ArrayList(m.keySet());
            Collections.sort(names);
            LinkedHashMap<Integer, String> dataMap = new LinkedHashMap<Integer, String>();
            LinkedHashMap<Integer, String> ptMap = new LinkedHashMap<Integer, String>();
            LinkedHashMap<Integer, String> prMap = new LinkedHashMap<Integer, String>();
            LinkedHashMap<Integer, String> dMap = new LinkedHashMap<Integer, String>();
            String maxKey = "";
            int i = 0;
            for (IDataElement de : m.values()) {
                String data = de.getData();
                if (data.length() > maxKey.length()) {
                    maxKey = data;
                }
                if (data.startsWith("public")) {
                    dataMap.put(i++, data);
                    continue;
                }
                if (data.startsWith("protected")) {
                    ptMap.put(i++, data);
                    continue;
                }
                if (data.startsWith("private")) {
                    prMap.put(i++, data);
                    continue;
                }
                dMap.put(i++, data);
            }
            dataMap.putAll(ptMap);
            dataMap.putAll(prMap);
            dataMap.putAll(dMap);
            builder.append("Methods: [").append('\n');
            Iterator<Object> iterator = dataMap.keySet().iterator();
            while (iterator.hasNext()) {
                int pos = (Integer)iterator.next();
                StringBuilder sp = new StringBuilder(" ");
                for (int j = 0; j < String.valueOf(names.size()).length() - String.valueOf(pos).length(); ++j) {
                    sp.append(" ");
                }
                builder.append(" ").append(pos).append((CharSequence)sp).append((String)dataMap.get(pos)).append('\n');
            }
            builder.append("]");
        }
        return builder.toString();
    }

    public String toString() {
        return this.getInfo().replaceAll("\\n", System.lineSeparator());
    }
}

